@extends('frontend.v2.layouts.app')

@section('title', 'Busca: ' . $query)

@section('content')
<div class="search-page-v2">
    <div class="search-header-v2">
        <h1>Resultados da Busca</h1>
        <p>Você pesquisou por: <strong>"{{ $query }}"</strong></p>
        <p class="search-count">{{ $news->total() }} resultado(s) encontrado(s)</p>
    </div>

    <div class="news-feed">
        @forelse($news as $item)
        <article class="news-item">
            <div class="news-item-content">
                <div class="news-item-image">
                    <a href="{{ route('news.show', $item->slug) }}">
                        <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
                    </a>
                </div>
                <div class="news-item-text">
                    <div class="news-item-meta">
                        <span class="news-category" style="color: {{ $item->category->color ?? '#3b82f6' }};">
                            {{ $item->category->name }}
                        </span>
                        <span class="news-date">{{ $item->published_at->format('d/m/Y') }}</span>
                    </div>
                    <h2 class="news-item-title">
                        <a href="{{ route('news.show', $item->slug) }}">{{ $item->title }}</a>
                    </h2>
                    <p class="news-item-excerpt">{{ Str::limit($item->excerpt, 200) }}</p>
                    <div class="news-item-footer">
                        <a href="{{ route('news.show', $item->slug) }}" class="read-more">Ler mais →</a>
                    </div>
                </div>
            </div>
        </article>
        @empty
        <div class="no-results">
            <p>Nenhum resultado encontrado para "{{ $query }}"</p>
        </div>
        @endforelse
    </div>

    @if($news->hasPages())
    <div class="pagination-wrapper">
        {{ $news->links() }}
    </div>
    @endif
</div>
@endsection

@section('sidebar')
@include('frontend.v2.partials.sidebar', [
    'sidebarAds' => $sidebarAds ?? [],
    'mostRead' => collect(),
    'latestPosts' => collect()
])
@endsection

