<!-- Anúncio 300x600 -->
@if(isset($sidebarAds['vertical_300x600']) && $sidebarAds['vertical_300x600'])
<div class="sidebar-ad">
    @if($sidebarAds['vertical_300x600']->format === 'image' && $sidebarAds['vertical_300x600']->image)
        <a href="{{ $sidebarAds['vertical_300x600']->link ?? '#' }}" target="_blank">
            <img src="{{ Storage::url($sidebarAds['vertical_300x600']->image) }}" alt="Anúncio" style="width: 300px; height: 600px; object-fit: cover;">
        </a>
    @elseif($sidebarAds['vertical_300x600']->format === 'html')
        {!! $sidebarAds['vertical_300x600']->content !!}
    @elseif($sidebarAds['vertical_300x600']->format === 'script')
        {!! $sidebarAds['vertical_300x600']->content !!}
    @endif
</div>
@endif

<!-- Mais Lidas -->
@if(isset($mostRead) && $mostRead->count() > 0)
<div class="sidebar-widget">
    <h3 class="widget-title">Mais Lidas</h3>
    <ul class="widget-list">
        @foreach($mostRead as $read)
        <li>
            <a href="{{ route('news.show', $read->slug) }}">
                <span class="widget-number">{{ $loop->iteration }}</span>
                <span class="widget-text">{{ Str::limit($read->title, 60) }}</span>
            </a>
        </li>
        @endforeach
    </ul>
</div>
@endif

<!-- Anúncio 300x250 -->
@if(isset($sidebarAds['rectangle_300x250']) && $sidebarAds['rectangle_300x250'])
<div class="sidebar-ad">
    @if($sidebarAds['rectangle_300x250']->format === 'image' && $sidebarAds['rectangle_300x250']->image)
        <a href="{{ $sidebarAds['rectangle_300x250']->link ?? '#' }}" target="_blank">
            <img src="{{ Storage::url($sidebarAds['rectangle_300x250']->image) }}" alt="Anúncio" style="width: 300px; height: 250px; object-fit: cover;">
        </a>
    @elseif($sidebarAds['rectangle_300x250']->format === 'html')
        {!! $sidebarAds['rectangle_300x250']->content !!}
    @elseif($sidebarAds['rectangle_300x250']->format === 'script')
        {!! $sidebarAds['rectangle_300x250']->content !!}
    @endif
</div>
@endif

<!-- Últimos Posts -->
@if(isset($latestPosts) && $latestPosts->count() > 0)
<div class="sidebar-widget">
    <h3 class="widget-title">Últimos Posts</h3>
    <ul class="widget-list">
        @foreach($latestPosts as $post)
        <li>
            <a href="{{ route('news.show', $post->slug) }}">
                <div class="widget-post-image">
                    <img src="{{ Storage::url($post->cover_image ?? 'default.jpg') }}" alt="{{ $post->title }}">
                </div>
                <div class="widget-post-content">
                    <span class="widget-post-title">{{ Str::limit($post->title, 50) }}</span>
                    <span class="widget-post-date">{{ $post->published_at->format('d/m/Y') }}</span>
                </div>
            </a>
        </li>
        @endforeach
    </ul>
</div>
@endif

