<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Portal de Notícias')</title>
    
    <!-- SEO -->
    <meta name="description" content="@yield('description', 'Portal de notícias atualizado')">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="{{ asset('css/v2/main.css') }}">
    @stack('styles')
</head>
<body>
    <!-- Topo -->
    <header class="site-header-v2">
        <div class="container">
            <div class="header-top">
                <div class="logo-v2">
                    <a href="{{ route('home') }}">
                        <div class="logo-circle" style="background: {{ setting('logo_bg_color', '#dc2626') }};">
                            {{ setting('site_name_short', 'GIRO') }}
                        </div>
                        <div class="logo-text-v2">
                            <span class="logo-main">{{ setting('site_name', 'Portal de Notícias') }}</span>
                            <span class="logo-slogan">{{ setting('site_slogan', 'A informação em primeiro lugar') }}</span>
                        </div>
                    </a>
                </div>
                <div class="header-top-right">
                    <span class="header-connect">{{ setting('header_text', 'CONECTANDO VOCÊ COM O') }}</span>
                </div>
            </div>
            <div class="header-nav">
                <nav class="main-menu">
                    <ul>
                        <li><a href="{{ route('home') }}">HOME</a></li>
                        @foreach(\App\Models\Category::where('status', 'active')->orderBy('order')->limit(5)->get() as $category)
                        <li><a href="{{ route('category.show', $category->slug) }}">{{ strtoupper($category->name) }}</a></li>
                        @endforeach
                        <li><a href="/contato">CONTATO</a></li>
                    </ul>
                </nav>
                <div class="search-bar-v2">
                    <form action="{{ route('news.search') }}" method="GET">
                        <input type="search" name="q" placeholder="Buscar..." value="{{ request('q') }}">
                        <button type="submit"><i class="bi bi-search"></i></button>
                    </form>
                </div>
            </div>
        </div>
    </header>

    <!-- Conteúdo Principal -->
    <main class="main-content-v2">
        <div class="container">
            <div class="content-wrapper">
                <div class="content-main">
                    @yield('content')
                </div>
                
                <!-- Sidebar -->
                <aside class="sidebar-v2">
                    @yield('sidebar')
                </aside>
            </div>
        </div>
    </main>

    <!-- Rodapé -->
    <footer class="site-footer-v2">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h4>Contato</h4>
                    <p>{{ setting('contact_email', 'contato@portal.com') }}</p>
                    <p>{{ setting('contact_phone', '(00) 0000-0000') }}</p>
                </div>
                <div class="footer-section">
                    <h4>Redes Sociais</h4>
                    <div class="footer-social">
                        <a href="#"><i class="bi bi-facebook"></i></a>
                        <a href="#"><i class="bi bi-instagram"></i></a>
                        <a href="#"><i class="bi bi-twitter"></i></a>
                    </div>
                </div>
                <div class="footer-section">
                    <ul class="footer-menu">
                        <li><a href="/sobre">Sobre</a></li>
                        <li><a href="/contato">Contato</a></li>
                        <li><a href="/anuncie">Anuncie</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; {{ date('Y') }} Portal de Notícias. Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="{{ asset('js/v2/main.js') }}"></script>
    @stack('scripts')
</body>
</html>
