@extends('frontend.v1.layouts.app')

@section('title', 'Busca: ' . $query)

@section('content')
<div class="search-page">
    <div class="container">
        <div class="search-header">
            <h1>Resultados da Busca</h1>
            <p>Você pesquisou por: <strong>"{{ $query }}"</strong></p>
            <p class="search-count">{{ $news->total() }} resultado(s) encontrado(s)</p>
        </div>

        <div class="search-results">
            @forelse($news as $item)
            <article class="search-result-item">
                <a href="{{ route('news.show', $item->slug) }}">
                    <div class="search-result-image">
                        <img src="{{ Storage::url($item->cover_image ?? 'default.jpg') }}" alt="{{ $item->title }}">
                    </div>
                    <div class="search-result-content">
                        <span class="search-result-category" style="color: {{ $item->category->color ?? '#3b82f6' }};">
                            {{ $item->category->name }}
                        </span>
                        <h3>{{ $item->title }}</h3>
                        <p>{{ Str::limit($item->excerpt, 150) }}</p>
                        <div class="search-result-meta">
                            <span>{{ $item->published_at->format('d/m/Y') }}</span>
                            <span>{{ $item->user->name }}</span>
                        </div>
                    </div>
                </a>
            </article>
            @empty
            <div class="no-results">
                <p>Nenhum resultado encontrado para "{{ $query }}"</p>
            </div>
            @endforelse
        </div>

        @if($news->hasPages())
        <div class="pagination-wrapper">
            {{ $news->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

