@if(!isset($section) || $section === 'weather')
<!-- Widget de Clima -->
<div class="widget widget-weather">
    <h3 class="widget-title">Clima</h3>
    <div class="weather-content">
        <div class="weather-icon">
            <i class="bi bi-cloud-sun"></i>
        </div>
        <div class="weather-info">
            <span class="weather-temp">--°C</span>
            <span class="weather-city">Carregando...</span>
        </div>
    </div>
    <script src="{{ asset('js/v1/weather.js') }}"></script>
</div>
@endif

<!-- Widget de Mais Lidas -->
@if(isset($mostRead) && $mostRead->count() > 0)
<div class="widget widget-popular">
    <h3 class="widget-title">Mais Lidas</h3>
    <ul class="widget-list">
        @foreach($mostRead as $read)
        <li>
            <a href="{{ route('news.show.v1', $read->slug) }}">
                <span class="widget-number">{{ $loop->iteration }}</span>
                <span class="widget-text">{{ Str::limit($read->title, 60) }}</span>
            </a>
        </li>
        @endforeach
    </ul>
</div>
@endif

@if((!isset($section) || $section === 'videos') && isset($recentVideos) && $recentVideos->count() > 0)
<!-- Widget de Vídeos -->
<div class="widget widget-videos">
    <h3 class="widget-title">Vídeos</h3>
    <div class="widget-videos-list">
        @foreach($recentVideos->take(3) as $video)
        <div class="widget-video-item">
            <a href="#">
                <div class="widget-video-thumb">
                    <img src="{{ Storage::url($video->thumbnail ?? 'default.jpg') }}" alt="{{ $video->title }}">
                    <div class="widget-video-play"><i class="bi bi-play-circle-fill"></i></div>
                </div>
                <h4>{{ Str::limit($video->title, 50) }}</h4>
            </a>
        </div>
        @endforeach
    </div>
</div>
@endif

@if((!isset($section) || $section === 'recent') && isset($latestNews) && $latestNews->count() > 0)
<!-- Widget de Posts Recentes -->
<div class="widget widget-recent">
    <h3 class="widget-title">Posts Recentes</h3>
    <ul class="widget-list">
        @foreach($latestNews as $latest)
        <li>
            <a href="{{ route('news.show', $latest->slug) }}">
                <div class="widget-post-image">
                    <img src="{{ Storage::url($latest->cover_image ?? 'default.jpg') }}" alt="{{ $latest->title }}">
                </div>
                <div class="widget-post-content">
                    <span class="widget-post-title">{{ Str::limit($latest->title, 50) }}</span>
                    <span class="widget-post-date">{{ $latest->published_at->format('d/m/Y') }}</span>
                </div>
            </a>
        </li>
        @endforeach
    </ul>
</div>
@endif

<style>
    .widget {
        background: white;
        padding: 20px;
        border-radius: 12px;
        margin-bottom: 30px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .widget-title {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 2px solid #3b82f6;
    }
    
    .widget-weather {
        text-align: center;
    }
    
    .weather-content {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
    }
    
    .weather-icon {
        font-size: 48px;
        color: #3b82f6;
    }
    
    .weather-info {
        display: flex;
        flex-direction: column;
    }
    
    .weather-temp {
        font-size: 24px;
        font-weight: 700;
        color: #1e293b;
    }
    
    .weather-city {
        font-size: 14px;
        color: #64748b;
    }
    
    .widget-videos-list {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }
    
    .widget-video-item h4 {
        font-size: 14px;
        font-weight: 600;
        margin-top: 8px;
        color: #1e293b;
    }
    
    .widget-video-thumb {
        position: relative;
        height: 120px;
        border-radius: 8px;
        overflow: hidden;
    }
    
    .widget-video-thumb img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .widget-video-play {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        font-size: 36px;
        color: white;
        opacity: 0.9;
    }
</style>

