@if(isset($items) && $items->hasPages())
<div class="pagination-wrapper">
    <div class="pagination">
        {{-- Previous Page Link --}}
        @if ($items->onFirstPage())
            <span class="pagination-item disabled">&laquo; Anterior</span>
        @else
            <a href="{{ $items->previousPageUrl() }}" class="pagination-item">&laquo; Anterior</a>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($items->getUrlRange(1, $items->lastPage()) as $page => $url)
            @if ($page == $items->currentPage())
                <span class="pagination-item active">{{ $page }}</span>
            @else
                <a href="{{ $url }}" class="pagination-item">{{ $page }}</a>
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($items->hasMorePages())
            <a href="{{ $items->nextPageUrl() }}" class="pagination-item">Próxima &raquo;</a>
        @else
            <span class="pagination-item disabled">Próxima &raquo;</span>
        @endif
    </div>
</div>
@endif

<style>
    .pagination-wrapper {
        margin: 40px 0;
        display: flex;
        justify-content: center;
    }
    
    .pagination {
        display: flex;
        gap: 5px;
        align-items: center;
    }
    
    .pagination-item {
        padding: 10px 15px;
        background: white;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        text-decoration: none;
        color: #374151;
        font-weight: 500;
        transition: all 0.3s;
    }
    
    .pagination-item:hover:not(.disabled):not(.active) {
        background: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }
    
    .pagination-item.active {
        background: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }
    
    .pagination-item.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
</style>

