@extends('frontend.v1.layouts.app')

@section('title', $news->meta_title ?: $news->title . ' - ' . config('app.name'))
@section('description', $news->meta_description ?: Str::limit(strip_tags($news->excerpt), 160))

@section('content')
<div class="container">
    <div class="news-layout">
        <!-- Conteúdo Principal -->
        <article class="news-main">
            <!-- Categoria e Data -->
            <div class="news-meta">
                <span class="news-category" style="color: {{ $news->category->color }}">{{ $news->category->name }}</span>
                <span class="news-date">{{ $news->published_at->format('d/m/Y H:i') }}</span>
                <span class="news-author">Por {{ $news->user->name }}</span>
            </div>

            <!-- Título -->
            <h1 class="news-title">{{ $news->title }}</h1>
            @if($news->subtitle)
            <h2 class="news-subtitle">{{ $news->subtitle }}</h2>
            @endif

            <!-- Compartilhamento -->
            <div class="news-share">
                <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank" class="share-btn share-facebook">Facebook</a>
                <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($news->title) }}" target="_blank" class="share-btn share-twitter">Twitter</a>
                <a href="https://api.whatsapp.com/send?text={{ urlencode($news->title . ' ' . url()->current()) }}" target="_blank" class="share-btn share-whatsapp">WhatsApp</a>
            </div>

            <!-- Foto de Capa -->
            @if($news->cover_image)
            <figure class="news-image">
                <img src="{{ Storage::url($news->cover_image) }}" alt="{{ $news->title }}">
                @if($news->cover_credit)
                <figcaption>{{ $news->cover_credit }}</figcaption>
                @endif
            </figure>
            @endif

            <!-- Corpo do Texto -->
            <div class="news-body">
                {!! $news->body !!}
            </div>

            <!-- Tags -->
            @if($news->tags->count() > 0)
            <div class="news-tags">
                <strong>Tags:</strong>
                @foreach($news->tags as $tag)
                <a href="/tag/{{ $tag->slug }}" class="tag">{{ $tag->name }}</a>
                @endforeach
            </div>
            @endif

            <!-- Rodapé da Notícia -->
            <div class="news-footer">
                <div class="news-author-info">
                    <strong>{{ $news->user->name }}</strong>
                    <p>Jornalista</p>
                </div>
                <div class="news-share-footer">
                    <strong>Compartilhar:</strong>
                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank">Facebook</a>
                    <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}" target="_blank">Twitter</a>
                    <a href="https://api.whatsapp.com/send?text={{ urlencode($news->title . ' ' . url()->current()) }}" target="_blank">WhatsApp</a>
                </div>
            </div>

            <!-- Leia Também -->
            @if($relatedNews->count() > 0)
            <section class="related-news">
                <h3>Leia Também</h3>
                <div class="related-grid">
                    @foreach($relatedNews->take(3) as $related)
                    <article class="related-card">
                        <a href="{{ route('v1.news', $related->slug) }}">
                            <img src="{{ Storage::url($related->cover_image) }}" alt="{{ $related->title }}">
                            <h4>{{ Str::limit($related->title, 70) }}</h4>
                        </a>
                    </article>
                    @endforeach
                </div>
            </section>
            @endif
        </article>

        <!-- Sidebar -->
        <aside class="news-sidebar">
            <!-- Banner 300x600 -->
            @if(isset($ads['skyscraper']))
            <div class="sidebar-ad">
                @if($ads['skyscraper']->format === 'image')
                <a href="{{ $ads['skyscraper']->link }}" target="_blank" onclick="trackAdClick({{ $ads['skyscraper']->id }})">
                    <img src="{{ Storage::url($ads['skyscraper']->image) }}" alt="Anúncio">
                </a>
                @else
                {!! $ads['skyscraper']->content !!}
                @endif
            </div>
            @endif

            <!-- Widget de Clima -->
            @include('frontend.v1.partials.widgets', ['section' => 'weather'])

            <!-- Mais Lidas -->
            <div class="sidebar-widget">
                <h3>Mais Lidas</h3>
                <ul class="most-read-list">
                    @foreach($mostRead as $item)
                    <li>
                        <a href="{{ route('news.show', $item->slug) }}">
                            <span class="read-number">{{ $loop->iteration }}</span>
                            <span class="read-title">{{ Str::limit($item->title, 60) }}</span>
                        </a>
                    </li>
                    @endforeach
                </ul>
            </div>

            <!-- Widget de Vídeos -->
            @include('frontend.v1.partials.widgets', ['section' => 'videos', 'recentVideos' => $recentVideos ?? collect()])

            <!-- Banner 300x250 -->
            @if(isset($ads['rectangle']))
            <div class="sidebar-ad">
                @if($ads['rectangle']->format === 'image')
                <a href="{{ $ads['rectangle']->link }}" target="_blank" onclick="trackAdClick({{ $ads['rectangle']->id }})">
                    <img src="{{ Storage::url($ads['rectangle']->image) }}" alt="Anúncio">
                </a>
                @else
                {!! $ads['rectangle']->content !!}
                @endif
            </div>
            @endif

            <!-- Posts Recentes -->
            @include('frontend.v1.partials.widgets', ['section' => 'recent', 'latestNews' => $latestPosts ?? collect()])
        </aside>
    </div>
</div>

@push('scripts')
<script>
function trackAdClick(adId) {
    fetch('/api/ads/' + adId + '/click', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    });
}
</script>
@endpush
@endsection

