<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Portal de Notícias')</title>
    
    <!-- SEO -->
    <meta name="description" content="@yield('description', 'Portal de notícias atualizado')">
    <meta name="keywords" content="@yield('keywords', 'notícias, jornalismo, informação')">
    
    <!-- Open Graph -->
    <meta property="og:title" content="@yield('og_title', 'Portal de Notícias')">
    <meta property="og:description" content="@yield('og_description', '')">
    <meta property="og:image" content="@yield('og_image', asset('images/logo.png'))">
    <meta property="og:url" content="{{ url()->current() }}">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="{{ asset('css/v1/main.css') }}">
    @stack('styles')
</head>
<body>
    <!-- Topo / Header -->
    <header class="site-header">
        <!-- Barra Superior -->
        <div class="top-bar" style="background: {{ setting('top_bar_color', '#1e3a8a') }};">
            <div class="container">
                <div class="top-bar-content">
                    <div class="top-bar-left">
                        <div class="logo-top">
                            <a href="{{ route('home') }}">
                                <img src="{{ asset('images/logo-white.png') }}" alt="{{ setting('site_name', 'Portal de Notícias') }}">
                                <span class="logo-text">{{ setting('site_name', 'Portal de Notícias') }}</span>
                            </a>
                        </div>
                    </div>
                    <div class="top-bar-right">
                        <a href="{{ setting('social_facebook', '#') }}" class="social-link" target="_blank"><i class="bi bi-facebook"></i></a>
                        <a href="{{ setting('social_instagram', '#') }}" class="social-link" target="_blank"><i class="bi bi-instagram"></i></a>
                        <a href="{{ setting('social_twitter', '#') }}" class="social-link" target="_blank"><i class="bi bi-twitter"></i></a>
                        <a href="{{ setting('social_youtube', '#') }}" class="social-link" target="_blank"><i class="bi bi-youtube"></i></a>
                        <a href="{{ setting('social_tiktok', '#') }}" class="social-link" target="_blank"><i class="bi bi-tiktok"></i></a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Menu Principal -->
        <nav class="main-nav">
            <div class="container">
                <div class="nav-content">
                    <div class="logo">
                        <a href="{{ route('home') }}">
                            <img src="{{ asset('images/logo.png') }}" alt="{{ setting('site_name', 'Portal de Notícias') }}">
                        </a>
                    </div>
                    <ul class="main-menu">
                        @foreach(\App\Models\Category::where('status', 'active')->orderBy('order')->limit(20)->get() as $category)
                        <li class="menu-item">
                            <a href="{{ route('category.show', $category->slug) }}">{{ $category->name }}</a>
                            @if($category->news()->where('status', 'published')->count() > 0)
                            <ul class="sub-menu">
                                @foreach($category->news()->where('status', 'published')->latest('published_at')->limit(5)->get() as $subNews)
                                <li><a href="{{ route('news.show', $subNews->slug) }}">{{ Str::limit($subNews->title, 60) }}</a></li>
                                @endforeach
                            </ul>
                            @endif
                        </li>
                        @endforeach
                    </ul>
                    <div class="nav-actions">
                        <form action="{{ route('news.search') }}" method="GET" class="search-form" id="search-form">
                            <input type="search" name="q" placeholder="Buscar notícias..." value="{{ request('q') }}">
                            <button type="submit"><i class="bi bi-search"></i></button>
                        </form>
                        <button class="search-toggle"><i class="bi bi-search"></i></button>
                        <button class="menu-toggle"><i class="bi bi-list"></i></button>
                    </div>
                </div>
            </div>
        </nav>
    </header>

    <!-- Conteúdo Principal -->
    <main class="main-content">
        @yield('content')
    </main>

    <!-- Rodapé -->
    <footer class="site-footer" style="background: {{ setting('footer_color', '#1e3a8a') }};">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <div class="footer-logo">
                        <img src="{{ asset('images/logo-white.png') }}" alt="Logo">
                    </div>
                    <p class="footer-description">
                        Portal de notícias atualizado com as principais informações do Brasil e do mundo.
                    </p>
                </div>
                
                <div class="footer-section">
                    <h4>Links Institucionais</h4>
                    <ul class="footer-links">
                        <li><a href="/sobre">Sobre Nós</a></li>
                        <li><a href="/contato">Contato</a></li>
                        <li><a href="/anuncie">Anuncie</a></li>
                        <li><a href="/trabalhe-conosco">Trabalhe Conosco</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h4>Contato</h4>
                    <ul class="footer-contact">
                        <li><i class="bi bi-envelope"></i> {{ setting('contact_email', 'contato@portal.com') }}</li>
                        <li><i class="bi bi-telephone"></i> {{ setting('contact_phone', '(00) 0000-0000') }}</li>
                        <li><i class="bi bi-whatsapp"></i> {{ setting('contact_whatsapp', '(00) 00000-0000') }}</li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h4>Redes Sociais</h4>
                    <div class="footer-social">
                        <a href="#"><i class="bi bi-facebook"></i></a>
                        <a href="#"><i class="bi bi-instagram"></i></a>
                        <a href="#"><i class="bi bi-twitter"></i></a>
                        <a href="#"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; {{ date('Y') }} Portal de Notícias. Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="{{ asset('js/v1/main.js') }}"></script>
    <script src="{{ asset('js/v1/weather.js') }}"></script>
    @stack('scripts')
</body>
</html>
