@extends('admin.layouts.app')

@section('title', 'Configurações de Templates')

@section('content')
<div class="settings-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Configurações de Templates</h2>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Selecionar Template do Site</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.settings.templates.update') }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-4">
                    <label class="form-label">Template Ativo <span class="text-danger">*</span></label>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="template-option {{ setting('active_template', 'v1') === 'v1' ? 'active' : '' }}" onclick="selectTemplate('v1')">
                                <input type="radio" name="active_template" value="v1" id="template_v1" 
                                       {{ setting('active_template', 'v1') === 'v1' ? 'checked' : '' }}>
                                <label for="template_v1" class="template-label">
                                    <div class="template-preview">
                                        <div class="template-header" style="background: #1e3a8a;">
                                            <div class="template-logo">Folha Vitória</div>
                                            <div class="template-menu">
                                                <span></span><span></span><span></span><span></span>
                                            </div>
                                        </div>
                                        <div class="template-content">
                                            <div class="template-grid">
                                                <div class="template-item large"></div>
                                                <div class="template-item"></div>
                                                <div class="template-item"></div>
                                                <div class="template-item"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <h4>Template V1 - Moderno</h4>
                                    <p>Estilo Folha Vitória - Layout modular com blocos e seções</p>
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="template-option {{ setting('active_template', 'v1') === 'v2' ? 'active' : '' }}" onclick="selectTemplate('v2')">
                                <input type="radio" name="active_template" value="v2" id="template_v2" 
                                       {{ setting('active_template', 'v1') === 'v2' ? 'checked' : '' }}>
                                <label for="template_v2" class="template-label">
                                    <div class="template-preview">
                                        <div class="template-header" style="background: #3b82f6;">
                                            <div class="template-logo-small">GIRO</div>
                                            <div class="template-menu-simple">
                                                <span></span><span></span><span></span>
                                            </div>
                                        </div>
                                        <div class="template-content">
                                            <div class="template-feed">
                                                <div class="template-feed-item"></div>
                                                <div class="template-feed-item"></div>
                                                <div class="template-feed-item"></div>
                                            </div>
                                            <div class="template-sidebar">
                                                <div class="template-ad"></div>
                                                <div class="template-ad"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <h4>Template V2 - Blog Simples</h4>
                                    <p>Estilo Giro Ipiaú - Feed linear com sidebar de anúncios</p>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Salvar Configuração
                    </button>
                    <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">Preview dos Templates</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Template V1:</strong></p>
                    <a href="{{ route('home.v1') }}" target="_blank" class="btn btn-outline-primary">
                        <i class="bi bi-eye"></i> Ver Template V1
                    </a>
                </div>
                <div class="col-md-6">
                    <p><strong>Template V2:</strong></p>
                    <a href="{{ route('home.v2') }}" target="_blank" class="btn btn-outline-primary">
                        <i class="bi bi-eye"></i> Ver Template V2
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .template-option {
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        padding: 20px;
        cursor: pointer;
        transition: all 0.3s;
        margin-bottom: 20px;
    }
    
    .template-option:hover {
        border-color: #3b82f6;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    
    .template-option.active {
        border-color: #3b82f6;
        background: #eff6ff;
    }
    
    .template-option input[type="radio"] {
        display: none;
    }
    
    .template-label {
        cursor: pointer;
        width: 100%;
    }
    
    .template-preview {
        background: #f9fafb;
        border-radius: 8px;
        overflow: hidden;
        margin-bottom: 15px;
        height: 200px;
    }
    
    .template-header {
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 0 15px;
        color: white;
    }
    
    .template-logo {
        font-weight: 700;
        font-size: 18px;
    }
    
    .template-logo-small {
        font-weight: 700;
        font-size: 14px;
        background: #dc2626;
        color: white;
        padding: 5px 10px;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .template-menu span {
        display: inline-block;
        width: 20px;
        height: 2px;
        background: white;
        margin: 0 2px;
    }
    
    .template-menu-simple {
        display: flex;
        gap: 10px;
    }
    
    .template-menu-simple span {
        display: inline-block;
        width: 30px;
        height: 3px;
        background: white;
    }
    
    .template-content {
        padding: 10px;
        height: 150px;
    }
    
    .template-grid {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 10px;
        height: 100%;
    }
    
    .template-item {
        background: #e5e7eb;
        border-radius: 4px;
    }
    
    .template-item.large {
        grid-row: span 2;
    }
    
    .template-feed {
        display: flex;
        flex-direction: column;
        gap: 10px;
        width: 60%;
        float: left;
    }
    
    .template-feed-item {
        background: #e5e7eb;
        height: 40px;
        border-radius: 4px;
    }
    
    .template-sidebar {
        width: 35%;
        float: right;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }
    
    .template-ad {
        background: #cbd5e1;
        height: 60px;
        border-radius: 4px;
    }
    
    .template-option h4 {
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 5px;
        color: #1e293b;
    }
    
    .template-option p {
        font-size: 14px;
        color: #64748b;
        margin: 0;
    }
</style>

<script>
    function selectTemplate(template) {
        document.querySelectorAll('.template-option').forEach(opt => {
            opt.classList.remove('active');
        });
        
        event.currentTarget.classList.add('active');
        document.getElementById('template_' + template).checked = true;
    }
</script>
@endsection

