@extends('admin.layouts.app')

@section('title', 'Plugins')

@section('content')
<div class="plugins-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Plugins</h2>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#uploadPluginModal">
            <i class="bi bi-upload"></i> Upload Manual
        </button>
    </div>

    <!-- Plugins Instalados -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Plugins Instalados</h5>
        </div>
        <div class="card-body">
            @if($installed->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Plugin</th>
                            <th>Tipo</th>
                            <th>Versão</th>
                            <th>Status</th>
                            <th>Instalado em</th>
                            <th width="200">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($installed as $plugin)
                        <tr>
                            <td>
                                <strong>{{ $plugin->plugin_name }}</strong>
                                <br>
                                <small class="text-muted">{{ $plugin->plugin_slug }}</small>
                            </td>
                            <td>
                                @php
                                    $pluginInfo = collect($plugins ?? [])->firstWhere('slug', $plugin->plugin_slug);
                                    $type = $pluginInfo['type'] ?? 'unknown';
                                @endphp
                                <span class="badge badge-{{ $type === 'premium' ? 'warning' : 'success' }}">
                                    {{ $type === 'premium' ? 'Premium' : 'Grátis' }}
                                </span>
                            </td>
                            <td>
                                <code>{{ $plugin->version }}</code>
                            </td>
                            <td>
                                @if($plugin->status === 'active')
                                    <span class="badge badge-success">Ativo</span>
                                @else
                                    <span class="badge badge-secondary">Inativo</span>
                                @endif
                            </td>
                            <td>
                                <small>{{ $plugin->installed_at->format('d/m/Y H:i') }}</small>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.plugins.configure', $plugin->id) }}" 
                                       class="btn btn-outline-primary" 
                                       title="Configurar">
                                        <i class="bi bi-gear"></i>
                                    </a>
                                    <form action="{{ route('admin.plugins.toggle', $plugin->id) }}" method="POST" style="display: inline;">
                                        @csrf
                                        <button type="submit" 
                                                class="btn btn-outline-{{ $plugin->status === 'active' ? 'warning' : 'success' }}"
                                                title="{{ $plugin->status === 'active' ? 'Desativar' : 'Ativar' }}">
                                            <i class="bi bi-{{ $plugin->status === 'active' ? 'pause' : 'play' }}"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.plugins.uninstall', $plugin->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Deseja realmente desinstalar este plugin?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-outline-danger" title="Desinstalar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @else
            <p class="text-muted text-center py-4">Nenhum plugin instalado</p>
            @endif
        </div>
    </div>

    <!-- Plugins Disponíveis -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Plugins Disponíveis</h5>
        </div>
        <div class="card-body">
            @if(isset($plugins) && count($plugins) > 0)
            <div class="row">
                @foreach($plugins as $plugin)
                @php
                    $isInstalled = $installed->has($plugin['slug']);
                @endphp
                <div class="col-md-6 mb-4">
                    <div class="card h-100 {{ $isInstalled ? 'border-success' : '' }}">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <h5 class="card-title">{{ $plugin['name'] }}</h5>
                                    <span class="badge badge-{{ $plugin['type'] === 'premium' ? 'warning' : 'success' }}">
                                        {{ $plugin['type'] === 'premium' ? 'Premium' : 'Grátis' }}
                                    </span>
                                    <span class="badge badge-info ms-1">v{{ $plugin['version'] ?? '1.0.0' }}</span>
                                </div>
                                @if($isInstalled)
                                    <span class="badge badge-success">Instalado</span>
                                @endif
                            </div>
                            <p class="card-text text-muted">{{ $plugin['description'] ?? 'Sem descrição' }}</p>
                            <div class="d-flex gap-2">
                                @if(!$isInstalled)
                                    <button type="button" 
                                            class="btn btn-primary btn-sm" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#installModal{{ $plugin['slug'] }}">
                                        <i class="bi bi-download"></i> Instalar
                                    </button>
                                @endif
                                @if(isset($plugin['documentation_url']))
                                    <a href="{{ $plugin['documentation_url'] }}" target="_blank" class="btn btn-outline-info btn-sm">
                                        <i class="bi bi-book"></i> Documentação
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Modal de Instalação -->
                    @if(!$isInstalled)
                    <div class="modal fade" id="installModal{{ $plugin['slug'] }}" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Instalar {{ $plugin['name'] }}</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form action="{{ route('admin.plugins.install', $plugin['slug']) }}" method="POST">
                                    @csrf
                                    <div class="modal-body">
                                        @if($plugin['type'] === 'premium')
                                        <div class="alert alert-warning">
                                            <i class="bi bi-exclamation-triangle"></i> Este é um plugin Premium e requer licença.
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Código de Licença <span class="text-danger">*</span></label>
                                            <input type="text" name="license_key" class="form-control" required placeholder="Digite o código de licença">
                                            <small class="text-muted">O código de licença é emitido pelo Painel Master</small>
                                        </div>
                                        @endif
                                        <p>{{ $plugin['description'] ?? '' }}</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                        <button type="submit" class="btn btn-primary">Instalar</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @else
            <p class="text-muted text-center py-4">Nenhum plugin disponível no catálogo</p>
            @endif
        </div>
    </div>
</div>

<!-- Modal Upload Manual -->
<div class="modal fade" id="uploadPluginModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Upload Manual de Plugin</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.plugins.upload') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Arquivo ZIP do Plugin</label>
                        <input type="file" name="plugin_file" class="form-control" accept=".zip" required>
                        <small class="text-muted">Faça upload do arquivo ZIP do plugin</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Upload e Instalar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

