<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Painel Administrativo') - Bahia Notícia</title>
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/admin.css') }}">
    
    @stack('styles')
</head>
<body>
    <div class="admin-wrapper">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <div class="logo">
                    <img src="{{ asset('images/logo.png') }}" alt="Bahia Notícia" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                    <span style="display: none; font-size: 1.5rem; font-weight: bold; color: #3b82f6;">Bahia Notícia</span>
                </div>
                <div class="header-time">
                    <i class="bi bi-clock"></i>
                    <span id="current-time"></span>
                </div>
                <div class="header-greeting">
                    <span id="greeting"></span>
                </div>
            </div>
            <div class="header-right">
                <div class="user-menu">
                    <div class="user-avatar">
                        <img src="{{ Auth::user()->avatar ?? asset('images/default-avatar.png') }}" 
                             alt="{{ Auth::user()->name }}" 
                             onerror="this.src='{{ asset('images/default-avatar.png') }}'">
                    </div>
                    <div class="user-info">
                        <span class="user-name">{{ Auth::user()->name }}</span>
                        <span class="user-role">{{ ucfirst(Auth::user()->role ?? 'Usuário') }}</span>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-link dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="bi bi-chevron-down"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="{{ route('admin.settings.general') }}"><i class="bi bi-gear"></i> Configurações</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form action="{{ route('logout') }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="dropdown-item text-danger">
                                        <i class="bi bi-box-arrow-right"></i> Sair
                                    </button>
                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </header>

        <!-- Sidebar -->
        <aside class="admin-sidebar">
            <nav class="sidebar-nav">
                <ul class="nav-menu">
                    <li class="nav-item">
                        <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                            <i class="bi bi-house-door"></i>
                            <span>Home / Dashboard</span>
                        </a>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-newspaper"></i>
                            <span>Notícias</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.news.create') }}" class="nav-link">Cadastrar Notícia</a></li>
                            <li><a href="{{ route('admin.news.index') }}" class="nav-link">Lista de Notícias</a></li>
                            <li><a href="{{ route('admin.categories.index') }}" class="nav-link">Gerir Categoria</a></li>
                        </ul>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-play-circle"></i>
                            <span>Vídeo</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.videos.create') }}" class="nav-link">Cadastrar Vídeo</a></li>
                            <li><a href="{{ route('admin.videos.index') }}" class="nav-link">Lista de Vídeo</a></li>
                        </ul>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-images"></i>
                            <span>Galeria</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.galleries.create') }}" class="nav-link">Cadastrar Galeria</a></li>
                            <li><a href="{{ route('admin.galleries.index') }}" class="nav-link">Lista de Galeria</a></li>
                        </ul>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-bar-chart"></i>
                            <span>Enquetes</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.polls.create') }}" class="nav-link">Cadastrar Enquete</a></li>
                            <li><a href="{{ route('admin.polls.index') }}" class="nav-link">Lista de Enquetes</a></li>
                        </ul>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-megaphone"></i>
                            <span>Anúncios</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.ads.create') }}" class="nav-link">Cadastrar Campanha</a></li>
                            <li><a href="{{ route('admin.ads.index') }}" class="nav-link">Lista de Campanhas</a></li>
                            <li><a href="{{ route('admin.ads.positions') }}" class="nav-link">Gerir Posições</a></li>
                        </ul>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-tags"></i>
                            <span>Classificados</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.classifieds.create') }}" class="nav-link">Cadastrar Classificado</a></li>
                            <li><a href="{{ route('admin.classifieds.index') }}" class="nav-link">Lista de Classificados</a></li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.plugins.index') }}" class="nav-link {{ request()->routeIs('admin.plugins.*') ? 'active' : '' }}">
                            <i class="bi bi-puzzle"></i>
                            <span>Plugins</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.users.index') }}" class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                            <i class="bi bi-people"></i>
                            <span>Usuários</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.municipalities.index') }}" class="nav-link {{ request()->routeIs('admin.municipalities.*') ? 'active' : '' }}">
                            <i class="bi bi-geo-alt"></i>
                            <span>Município</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.pages.index') }}" class="nav-link {{ request()->routeIs('admin.pages.*') ? 'active' : '' }}">
                            <i class="bi bi-file-text"></i>
                            <span>Páginas</span>
                        </a>
                    </li>

                    <li class="nav-item nav-group">
                        <a href="#" class="nav-link">
                            <i class="bi bi-gear"></i>
                            <span>Configurações</span>
                            <i class="bi bi-chevron-down ms-auto"></i>
                        </a>
                        <ul class="nav-submenu">
                            <li><a href="{{ route('admin.settings.general') }}" class="nav-link">Geral</a></li>
                            <li><a href="{{ route('admin.settings.templates') }}" class="nav-link">Templates</a></li>
                            <li><a href="{{ route('admin.settings.seo') }}" class="nav-link">SEO</a></li>
                            <li><a href="{{ route('admin.settings.scripts') }}" class="nav-link">Scripts</a></li>
                            <li><a href="{{ route('admin.settings.index') }}" class="nav-link">API Keys / Fuso Horário</a></li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.trash.index') }}" class="nav-link {{ request()->routeIs('admin.trash.*') ? 'active' : '' }}">
                            <i class="bi bi-trash"></i>
                            <span>Lixeira</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.reports.index') }}" class="nav-link {{ request()->routeIs('admin.reports.*') ? 'active' : '' }}">
                            <i class="bi bi-graph-up"></i>
                            <span>Relatórios</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="admin-main">
            <div class="container-fluid">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @yield('content')
            </div>
        </main>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        // Atualizar horário
        function updateTime() {
            const now = new Date();
            const timeString = now.toLocaleTimeString('pt-BR', { 
                hour: '2-digit', 
                minute: '2-digit',
                second: '2-digit'
            });
            document.getElementById('current-time').textContent = timeString;
        }
        setInterval(updateTime, 1000);
        updateTime();

        // Saudação por período
        function updateGreeting() {
            const hour = new Date().getHours();
            let greeting = 'Bom dia';
            if (hour >= 12 && hour < 18) {
                greeting = 'Boa tarde';
            } else if (hour >= 18) {
                greeting = 'Boa noite';
            }
            document.getElementById('greeting').textContent = greeting + ', ' + '{{ Auth::user()->name }}';
        }
        updateGreeting();

        // Toggle submenu
        document.querySelectorAll('.nav-group > .nav-link').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const submenu = this.nextElementSibling;
                const icon = this.querySelector('.bi-chevron-down');
                
                if (submenu) {
                    submenu.classList.toggle('show');
                    icon.classList.toggle('rotate');
                }
            });
        });

        // CSRF Token para AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    
    <script src="{{ asset('js/admin/header.js') }}"></script>
    @stack('scripts')
</body>
</html>

