// Template V1 - JavaScript Principal

document.addEventListener('DOMContentLoaded', function() {
    // Menu Mobile Toggle
    const menuToggle = document.querySelector('.menu-toggle');
    const mainMenu = document.querySelector('.main-menu');
    
    if (menuToggle && mainMenu) {
        menuToggle.addEventListener('click', function() {
            mainMenu.classList.toggle('active');
        });
    }

    // Search Toggle
    const searchToggle = document.querySelector('.search-toggle');
    const searchForm = document.getElementById('search-form');
    
    if (searchToggle) {
        searchToggle.addEventListener('click', function() {
            if (searchForm) {
                searchForm.classList.toggle('active');
                if (searchForm.classList.contains('active')) {
                    searchForm.querySelector('input[type="search"]')?.focus();
                }
            }
        });
    }

    // Smooth Scroll
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Lazy Loading Images
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    if (img.dataset.src) {
                        img.src = img.dataset.src;
                        img.removeAttribute('data-src');
                        observer.unobserve(img);
                    }
                }
            });
        });

        document.querySelectorAll('img[data-src]').forEach(img => {
            imageObserver.observe(img);
        });
    }

    // Compartilhamento
    window.copyToClipboard = function(text) {
        if (navigator.clipboard) {
            navigator.clipboard.writeText(text).then(function() {
                showNotification('Link copiado para a área de transferência!');
            });
        } else {
            // Fallback para navegadores antigos
            const textArea = document.createElement('textarea');
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.select();
            document.execCommand('copy');
            document.body.removeChild(textArea);
            showNotification('Link copiado!');
        }
    };

    // Notificação
    function showNotification(message) {
        const notification = document.createElement('div');
        notification.className = 'notification';
        notification.textContent = message;
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.classList.add('show');
        }, 10);

        setTimeout(() => {
            notification.classList.remove('show');
            setTimeout(() => {
                document.body.removeChild(notification);
            }, 300);
        }, 3000);
    }

    // Auto-hide submenu on mobile
    if (window.innerWidth <= 768) {
        document.querySelectorAll('.menu-item').forEach(item => {
            item.addEventListener('click', function(e) {
                if (this.querySelector('.sub-menu')) {
                    e.preventDefault();
                    this.classList.toggle('active');
                }
            });
        });
    }

    // Video Player Controls
    const videoPlayers = document.querySelectorAll('.video-player');
    videoPlayers.forEach(player => {
        const iframe = player.querySelector('iframe');
        if (iframe) {
            player.addEventListener('click', function() {
                // Adicionar controles de vídeo se necessário
            });
        }
    });
});

// Busca com Autocomplete (se implementado)
function initSearchAutocomplete() {
    const searchInput = document.querySelector('input[type="search"]');
    if (!searchInput) return;

    let timeout;
    searchInput.addEventListener('input', function() {
        clearTimeout(timeout);
        const query = this.value;

        if (query.length < 3) {
            hideAutocomplete();
            return;
        }

        timeout = setTimeout(() => {
            fetch(`/api/search/autocomplete?q=${encodeURIComponent(query)}`)
                .then(response => response.json())
                .then(data => {
                    showAutocomplete(data);
                })
                .catch(error => console.error('Erro na busca:', error));
        }, 300);
    });
}

function showAutocomplete(results) {
    // Implementar dropdown de autocomplete
}

function hideAutocomplete() {
    // Esconder dropdown
}

