// Atualizar horário local no header
document.addEventListener('DOMContentLoaded', function() {
    // Atualizar horário (pode ter id="current-time" ou id="localTime")
    const timeElement = document.getElementById('current-time') || document.getElementById('localTime');
    
    if (timeElement) {
        function updateTime() {
            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');
            timeElement.textContent = `${hours}:${minutes}:${seconds}`;
        }
        
        // Atualizar imediatamente
        updateTime();
        
        // Atualizar a cada segundo
        setInterval(updateTime, 1000);
    }
    
    // Atualizar saudação
    const greetingElement = document.getElementById('greeting');
    if (greetingElement && !greetingElement.textContent.trim()) {
        const hour = new Date().getHours();
        let greeting = 'Olá';
        
        if (hour >= 5 && hour < 12) {
            greeting = 'Bom dia';
        } else if (hour >= 12 && hour < 18) {
            greeting = 'Boa tarde';
        } else {
            greeting = 'Boa noite';
        }
        
        greetingElement.textContent = greeting;
    }
});

