<?php
/**
 * Script para instalar dependências do Composer
 * Execute este arquivo via navegador ou linha de comando
 * 
 * IMPORTANTE: Após executar, DELETE este arquivo por segurança!
 */

// Verificar se está sendo executado via CLI ou web
$isCli = php_sapi_name() === 'cli';

if (!$isCli) {
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Instalar Dependências</title>";
    echo "<style>body{font-family:Arial;max-width:800px;margin:50px auto;padding:20px;}pre{background:#f5f5f5;padding:15px;border-radius:5px;overflow-x:auto;}</style></head><body>";
    echo "<h1>Instalando Dependências do Composer</h1>";
    echo "<pre>";
}

$rootDir = __DIR__;
$composerPath = null;

// Procurar composer.phar ou comando composer
$possiblePaths = [
    $rootDir . '/composer.phar',
    '/usr/local/bin/composer',
    '/usr/bin/composer',
    '/opt/alt/php82/usr/bin/composer',
    '/opt/cpanel/ea-php82/root/usr/bin/composer',
    'composer' // Se estiver no PATH
];

echo "Procurando Composer...\n";
foreach ($possiblePaths as $path) {
    if ($path === 'composer') {
        // Tentar executar diretamente
        $output = [];
        $return = 0;
        exec('composer --version 2>&1', $output, $return);
        if ($return === 0) {
            $composerPath = 'composer';
            echo "✅ Composer encontrado no PATH\n";
            break;
        }
    } elseif (file_exists($path)) {
        $composerPath = $path;
        echo "✅ Composer encontrado: $path\n";
        break;
    }
}

// Se não encontrou, tentar baixar composer.phar
if (!$composerPath) {
    echo "⚠️  Composer não encontrado. Tentando baixar composer.phar...\n";
    
    $composerPhar = $rootDir . '/composer.phar';
    $composerUrl = 'https://getcomposer.org/download/latest-stable/composer.phar';
    
    echo "Baixando de: $composerUrl\n";
    
    $ch = curl_init($composerUrl);
    $fp = fopen($composerPhar, 'w');
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 300);
    
    $success = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    fclose($fp);
    
    if ($success && $httpCode === 200 && file_exists($composerPhar)) {
        // Tornar executável
        chmod($composerPhar, 0755);
        $composerPath = $composerPhar;
        echo "✅ composer.phar baixado com sucesso!\n";
    } else {
        echo "\n❌ Erro ao baixar composer.phar\n";
        echo "\n📋 INSTRUÇÕES MANUAIS:\n";
        echo "1. Acesse o servidor via SSH\n";
        echo "2. Execute os seguintes comandos:\n";
        echo "   cd /home/canal33portal/public_html\n";
        echo "   curl -sS https://getcomposer.org/installer | php\n";
        echo "   php composer.phar install --no-dev --optimize-autoloader\n";
        echo "\nOU se o Composer já estiver instalado:\n";
        echo "   composer install --no-dev --optimize-autoloader\n";
        
        if (!$isCli) {
            echo "</pre>";
            echo "<p><strong>Erro:</strong> Não foi possível baixar o Composer automaticamente.</p>";
            echo "<p>Por favor, siga as instruções acima ou entre em contato com o suporte.</p>";
            echo "</body></html>";
        }
        exit(1);
    }
}

if (!$composerPath) {
    die("❌ Composer não encontrado e não foi possível baixar!\n");
}

echo "Composer: $composerPath\n";
echo "Diretório: $rootDir\n\n";

// Verificar se composer.json existe
if (!file_exists($rootDir . '/composer.json')) {
    die("❌ composer.json não encontrado em: $rootDir\n");
}

echo "Instalando dependências...\n";
echo str_repeat("=", 50) . "\n\n";

// Executar composer install
$command = "php " . escapeshellarg($composerPath) . " install --no-dev --optimize-autoloader 2>&1";
$output = [];
$returnCode = 0;

exec($command, $output, $returnCode);

foreach ($output as $line) {
    echo $line . "\n";
}

echo "\n" . str_repeat("=", 50) . "\n";

if ($returnCode === 0) {
    echo "\n✅ Dependências instaladas com sucesso!\n";
    echo "⚠️  IMPORTANTE: Delete este arquivo (install-composer.php) por segurança!\n";
    
    // Verificar se vendor/autoload.php foi criado
    if (file_exists($rootDir . '/vendor/autoload.php')) {
        echo "✅ vendor/autoload.php criado com sucesso!\n";
        echo "\n🎉 Tudo pronto! O portal deve funcionar agora.\n";
    } else {
        echo "❌ Erro: vendor/autoload.php não foi criado!\n";
        echo "Verifique os erros acima.\n";
    }
    
    // Tentar limpar composer.phar se foi baixado
    if ($composerPath === $rootDir . '/composer.phar') {
        echo "\n💡 Dica: Você pode manter composer.phar para uso futuro ou deletá-lo.\n";
    }
} else {
    echo "\n❌ Erro ao instalar dependências (código: $returnCode)\n";
    echo "Verifique os erros acima.\n";
    echo "\nSe o erro persistir, tente executar manualmente via SSH:\n";
    echo "cd /home/canal33portal/public_html\n";
    if ($composerPath === $rootDir . '/composer.phar') {
        echo "php composer.phar install --no-dev --optimize-autoloader\n";
    } else {
        echo "composer install --no-dev --optimize-autoloader\n";
    }
}

if (!$isCli) {
    echo "</pre>";
    echo "<p><strong>IMPORTANTE:</strong> Delete este arquivo após a instalação!</p>";
    echo "</body></html>";
}
