<?php
/**
 * Script para completar instalação do Laravel
 * Cria arquivos faltantes e configura o projeto
 * 
 * IMPORTANTE: Após executar, DELETE este arquivo por segurança!
 */

$isCli = php_sapi_name() === 'cli';

if (!$isCli) {
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Completar Instalação</title>";
    echo "<style>body{font-family:Arial;max-width:900px;margin:50px auto;padding:20px;}pre{background:#f5f5f5;padding:15px;border-radius:5px;overflow-x:auto;}</style></head><body>";
    echo "<h1>Completando Instalação do Laravel</h1>";
    echo "<pre>";
}

$rootDir = __DIR__;
$errors = [];
$success = [];

echo "🔧 Completando instalação do Laravel...\n";
echo str_repeat("=", 60) . "\n\n";

// 1. Verificar/Criar .env
echo "1️⃣ Verificando arquivo .env...\n";
if (!file_exists($rootDir . '/.env')) {
    if (file_exists($rootDir . '/.env.example')) {
        copy($rootDir . '/.env.example', $rootDir . '/.env');
        $success[] = "✅ Arquivo .env criado a partir de .env.example";
    } else {
        $errors[] = "❌ Arquivo .env.example não encontrado";
    }
} else {
    $success[] = "✅ Arquivo .env já existe";
}
echo "\n";

// 2. Verificar/Criar artisan
echo "2️⃣ Verificando arquivo artisan...\n";
if (!file_exists($rootDir . '/artisan')) {
    $artisanContent = file_get_contents(__FILE__);
    // Não, vamos criar o artisan separadamente
    $artisanContent = '#!/usr/bin/env php
<?php

define(\'LARAVEL_START\', microtime(true));

require __DIR__.\'/vendor/autoload.php\';

$app = require_once __DIR__.\'/bootstrap/app.php\';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

$status = $kernel->handle(
    $input = new Symfony\Component\Console\Input\ArgvInput,
    new Symfony\Component\Console\Output\ConsoleOutput
);

$kernel->terminate($input, $status);

exit($status);
';
    file_put_contents($rootDir . '/artisan', $artisanContent);
    chmod($rootDir . '/artisan', 0755);
    $success[] = "✅ Arquivo artisan criado";
} else {
    $success[] = "✅ Arquivo artisan já existe";
}
echo "\n";

// 3. Gerar APP_KEY se não existir
echo "3️⃣ Verificando APP_KEY...\n";
if (file_exists($rootDir . '/.env')) {
    $envContent = file_get_contents($rootDir . '/.env');
    if (strpos($envContent, 'APP_KEY=') !== false && strpos($envContent, 'APP_KEY=base64:') === false && strpos($envContent, 'APP_KEY=') === strpos($envContent, 'APP_KEY=')) {
        // Verificar se APP_KEY está vazio
        if (preg_match('/APP_KEY=\s*$/', $envContent) || strpos($envContent, 'APP_KEY=') !== false && trim(explode('APP_KEY=', $envContent)[1]) === '') {
            echo "   Gerando APP_KEY...\n";
            $key = 'base64:' . base64_encode(random_bytes(32));
            $envContent = preg_replace('/APP_KEY=.*/', 'APP_KEY=' . $key, $envContent);
            file_put_contents($rootDir . '/.env', $envContent);
            $success[] = "✅ APP_KEY gerado";
        } else {
            $success[] = "✅ APP_KEY já configurado";
        }
    }
}
echo "\n";

// 4. Verificar permissões
echo "4️⃣ Verificando permissões...\n";
$dirs = [
    'storage' => 0755,
    'storage/app' => 0755,
    'storage/framework' => 0755,
    'storage/framework/cache' => 0755,
    'storage/framework/sessions' => 0755,
    'storage/framework/views' => 0755,
    'storage/logs' => 0755,
    'bootstrap/cache' => 0755,
];

foreach ($dirs as $dir => $perm) {
    $path = $rootDir . '/' . $dir;
    if (!is_dir($path)) {
        mkdir($path, $perm, true);
        $success[] = "✅ Diretório criado: $dir";
    } else {
        chmod($path, $perm);
        $success[] = "✅ Permissão verificada: $dir";
    }
}
echo "\n";

// 5. Corrigir Monolog
echo "5️⃣ Corrigindo problema do Monolog...\n";
$composerJson = json_decode(file_get_contents($rootDir . '/composer.json'), true);
if ($composerJson) {
    if (!isset($composerJson['require']['psr/log']) || strpos($composerJson['require']['psr/log'], '^3') === false) {
        $composerJson['require']['psr/log'] = '^3.0';
        file_put_contents($rootDir . '/composer.json', json_encode($composerJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        $success[] = "✅ composer.json atualizado para psr/log ^3.0";
    }
    if (!isset($composerJson['require']['monolog/monolog']) || (strpos($composerJson['require']['monolog/monolog'], '^3') === false && strpos($composerJson['require']['monolog/monolog'], '~3') === false)) {
        $composerJson['require']['monolog/monolog'] = '^3.0';
        file_put_contents($rootDir . '/composer.json', json_encode($composerJson, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        $success[] = "✅ composer.json atualizado para monolog/monolog ^3.0";
    }
}
echo "\n";

// 6. Reinstalar dependências
echo "6️⃣ Reinstalando dependências...\n";
echo str_repeat("-", 60) . "\n";

// Procurar composer
$composerPath = null;
$possiblePaths = [
    $rootDir . '/composer.phar',
    '/usr/local/bin/composer',
    '/usr/bin/composer',
    '/opt/alt/php82/usr/bin/composer',
    '/opt/cpanel/ea-php82/root/usr/bin/composer',
    'composer'
];

foreach ($possiblePaths as $path) {
    if ($path === 'composer') {
        $output = [];
        $return = 0;
        exec('composer --version 2>&1', $output, $return);
        if ($return === 0) {
            $composerPath = 'composer';
            break;
        }
    } elseif (file_exists($path)) {
        $composerPath = $path;
        break;
    }
}

if ($composerPath) {
    if ($composerPath !== 'composer') {
        $composerPath = "php " . escapeshellarg($composerPath);
    }
    
    // Remover vendor
    if (is_dir($rootDir . '/vendor')) {
        echo "   Removendo vendor/...\n";
        exec("rm -rf " . escapeshellarg($rootDir . '/vendor') . " 2>&1", $output, $return);
    }
    
    // Instalar
    echo "   Instalando dependências...\n";
    $command = $composerPath . " install --no-dev --optimize-autoloader 2>&1";
    $output = [];
    $returnCode = 0;
    
    exec($command, $output, $returnCode);
    
    foreach ($output as $line) {
        echo "   " . $line . "\n";
    }
    
    if ($returnCode === 0) {
        $success[] = "✅ Dependências instaladas";
    } else {
        $errors[] = "❌ Erro ao instalar dependências (código: $returnCode)";
    }
} else {
    $errors[] = "⚠️  Composer não encontrado. Execute manualmente: composer install --no-dev --optimize-autoloader";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "\n📊 RESUMO:\n\n";

foreach ($success as $msg) {
    echo $msg . "\n";
}

if (!empty($errors)) {
    echo "\n⚠️  AVISOS:\n\n";
    foreach ($errors as $msg) {
        echo $msg . "\n";
    }
}

if (empty($errors) || (count($errors) === 1 && strpos($errors[0], 'Composer não encontrado') !== false)) {
    echo "\n🎉 Instalação completada com sucesso!\n";
    echo "⚠️  IMPORTANTE: Delete este arquivo (completar-instalacao.php) por segurança!\n";
} else {
    echo "\n⚠️  Alguns erros ocorreram. Verifique acima.\n";
}

if (!$isCli) {
    echo "</pre>";
    echo "<p><strong>IMPORTANTE:</strong> Delete este arquivo após a instalação!</p>";
    echo "</body></html>";
}

