<?php

/*
|--------------------------------------------------------------------------
| Fix PSR Log Extension Conflict
|--------------------------------------------------------------------------
|
| If there's a PHP extension (PsrExt) conflicting with psr/log,
| we need to load Composer autoload first and create aliases.
|
*/

// Load Composer autoload BEFORE creating the app to ensure psr/log is loaded
if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require_once __DIR__ . '/../vendor/autoload.php';
    
    // If PsrExt extension exists, create aliases to use Composer library
    if (interface_exists('PsrExt\Log\LoggerInterface', false) && interface_exists('Psr\Log\LoggerInterface', false)) {
        // Force use of Composer's psr/log instead of extension
        if (!class_exists('PsrExt\Log\LoggerInterface', false)) {
            class_alias('Psr\Log\LoggerInterface', 'PsrExt\Log\LoggerInterface');
        }
    }
}

/*
|--------------------------------------------------------------------------
| Create The Application
|--------------------------------------------------------------------------
|
| The first thing we will do is create a new Laravel application instance
| which serves as the "glue" for all the components of Laravel, and is
| the IoC container for the system binding all of the various parts.
|
*/

$app = new Illuminate\Foundation\Application(
    $_ENV['APP_BASE_PATH'] ?? dirname(__DIR__)
);

/*
|--------------------------------------------------------------------------
| Bind Important Interfaces
|--------------------------------------------------------------------------
|
| Next, we need to bind some important interfaces into the container so
| we will be able to resolve them when needed. The kernels serve the
| incoming requests to this application from both the web and CLI.
|
*/

$app->singleton(
    Illuminate\Contracts\Http\Kernel::class,
    App\Http\Kernel::class
);

$app->singleton(
    Illuminate\Contracts\Console\Kernel::class,
    App\Console\Kernel::class
);

$app->singleton(
    Illuminate\Contracts\Debug\ExceptionHandler::class,
    App\Exceptions\Handler::class
);

/*
|--------------------------------------------------------------------------
| Return The Application
|--------------------------------------------------------------------------
|
| This script returns the application instance. The instance is given to
| the calling script so we can separate the building of the instances
| from the actual running of the application and sending responses.
|
*/

return $app;

