<?php

namespace App\Services\AutoPost\Adapters;

use SimpleXMLElement;

class RssAdapter extends BaseAdapter
{
    public function getName(): string
    {
        return 'rss';
    }

    public function fetch(string $url, array $config = []): array
    {
        $xmlContent = $this->httpGet($url);
        
        if (!$xmlContent) {
            return [];
        }

        try {
            $xml = new SimpleXMLElement($xmlContent);
            $items = [];

            foreach ($xml->channel->item as $item) {
                $items[] = $this->normalizeItem([
                    'title' => (string) $item->title,
                    'body' => (string) $item->description,
                    'url' => (string) $item->link,
                    'published_at' => isset($item->pubDate) ? date('Y-m-d H:i:s', strtotime($item->pubDate)) : now(),
                    'category' => isset($item->category) ? (string) $item->category : null,
                    'author' => isset($item->author) ? (string) $item->author : null,
                    'images' => $this->extractImages($item),
                ]);
            }

            return $items;
        } catch (\Exception $e) {
            \Log::error("RSS Parse Error: " . $e->getMessage());
            return [];
        }
    }

    protected function extractImages($item): array
    {
        $images = [];
        
        // Verificar media:content
        if (isset($item->children('media', true)->content)) {
            foreach ($item->children('media', true)->content as $media) {
                if (isset($media->attributes()->url)) {
                    $images[] = (string) $media->attributes()->url;
                }
            }
        }

        // Verificar enclosure
        if (isset($item->enclosure) && isset($item->enclosure['type'])) {
            if (strpos($item->enclosure['type'], 'image') !== false) {
                $images[] = (string) $item->enclosure['url'];
            }
        }

        return $images;
    }
}

