<?php

namespace App\Services\AutoPost\Adapters;

abstract class BaseAdapter
{
    abstract public function getName(): string;
    abstract public function fetch(string $url, array $config = []): array;

    /**
     * Normalizar item para formato padrão
     */
    protected function normalizeItem($item): array
    {
        return [
            'title' => $item['title'] ?? '',
            'subtitle' => $item['subtitle'] ?? null,
            'body' => $item['body'] ?? $item['content'] ?? '',
            'excerpt' => $item['excerpt'] ?? $item['description'] ?? null,
            'url' => $item['url'] ?? $item['link'] ?? null,
            'published_at' => $item['published_at'] ?? $item['date'] ?? now(),
            'category' => $item['category'] ?? null,
            'images' => $item['images'] ?? [],
            'author' => $item['author'] ?? null,
            'hash' => md5($item['url'] ?? $item['title'] ?? ''),
        ];
    }

    /**
     * Fazer requisição HTTP
     */
    protected function httpGet(string $url, array $headers = [])
    {
        try {
            $response = Http::timeout(30)->withHeaders($headers)->get($url);
            return $response->successful() ? $response->body() : null;
        } catch (\Exception $e) {
            \Log::error("HTTP Error: " . $e->getMessage());
            return null;
        }
    }
}

