<?php

namespace App\Services\AutoPost\Adapters;

class AgenciaXAdapter extends BaseAdapter
{
    public function getName(): string
    {
        return 'agencia_x';
    }

    public function fetch(string $url, array $config = []): array
    {
        // Similar ao Dino, mas com estrutura específica da Agência X
        $apiKey = $config['api_key'] ?? null;
        
        $response = $this->httpGet($url, [
            'X-API-Key' => $apiKey,
            'Accept' => 'application/json',
        ]);

        if (!$response) {
            return [];
        }

        $data = json_decode($response, true);
        $items = [];

        foreach ($data['items'] ?? $data['news'] ?? [] as $item) {
            $items[] = $this->normalizeItem([
                'title' => $item['titulo'] ?? $item['title'] ?? '',
                'body' => $item['texto'] ?? $item['content'] ?? '',
                'url' => $item['url'] ?? null,
                'published_at' => $item['data_publicacao'] ?? now(),
                'category' => $item['categoria'] ?? null,
                'images' => $item['imagens'] ?? [],
            ]);
        }

        return $items;
    }
}

