<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'avatar',
        'role',
        'status',
        'bio',
        'facebook',
        'twitter',
        'instagram',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'last_login' => 'datetime',
    ];

    /**
     * Relacionamento com notícias
     */
    public function news()
    {
        return $this->hasMany(News::class);
    }

    /**
     * Verificar se é administrador
     */
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    /**
     * Verificar se pode editar
     */
    public function canEdit()
    {
        return in_array($this->role, ['admin', 'editor']);
    }

    /**
     * Verificar se está ativo
     */
    public function isActive()
    {
        return $this->status === 'active';
    }
}

