<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class News extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'category_id',
        'title',
        'subtitle',
        'slug',
        'hat',
        'source',
        'cover_image',
        'cover_credit',
        'cover_width',
        'body',
        'excerpt',
        'access',
        'municipality_id',
        'blog_id',
        'column',
        'is_featured',
        'is_slide',
        'is_headline',
        'is_more_news',
        'is_urgent',
        'status',
        'published_at',
        'views',
        'meta_title',
        'meta_description',
        'canonical',
    ];

    protected $casts = [
        'published_at' => 'datetime',
        'is_featured' => 'boolean',
        'is_slide' => 'boolean',
        'is_headline' => 'boolean',
        'is_more_news' => 'boolean',
        'is_urgent' => 'boolean',
        'views' => 'integer',
    ];

    /**
     * Relacionamento com usuário
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relacionamento com categoria
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Relacionamento com tags
     */
    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'news_tags');
    }

    /**
     * Relacionamento com município
     */
    public function municipality()
    {
        return $this->belongsTo(Municipality::class);
    }

    /**
     * Relacionamento com galeria
     */
    public function gallery()
    {
        return $this->belongsTo(Gallery::class);
    }

    /**
     * Relacionamento com revisões
     */
    public function revisions()
    {
        return $this->hasMany(NewsRevision::class);
    }

    /**
     * Scope para notícias publicadas
     */
    public function scopePublished($query)
    {
        return $query->where('status', 'published')
            ->where('published_at', '<=', now());
    }

    /**
     * Scope para notícias em destaque
     */
    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }

    /**
     * Scope para notícias do slide
     */
    public function scopeSlide($query)
    {
        return $query->where('is_slide', true);
    }

    /**
     * Incrementar visualizações
     */
    public function incrementViews()
    {
        $this->increment('views');
    }
}

