<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstalledPlugin extends Model
{
    use HasFactory;

    protected $fillable = [
        'plugin_slug',
        'plugin_name',
        'version',
        'license_key',
        'config',
        'status',
        'installed_at',
    ];

    protected $casts = [
        'config' => 'array',
        'installed_at' => 'datetime',
    ];

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}

