<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AutoPostLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'job_id',
        'provider',
        'item_url',
        'item_title',
        'status',
        'news_id',
        'error_message',
    ];

    protected $casts = [
        'job_id' => 'integer',
        'news_id' => 'integer',
    ];

    public function job()
    {
        return $this->belongsTo(AutoPostJob::class, 'job_id');
    }

    public function news()
    {
        return $this->belongsTo(News::class, 'news_id');
    }

    public function scopeSuccess($query)
    {
        return $query->where('status', 'success');
    }

    public function scopeError($query)
    {
        return $query->where('status', 'error');
    }
}

