<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdPosition extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'width',
        'height',
        'description',
        'status',
    ];

    protected $casts = [
        'width' => 'integer',
        'height' => 'integer',
    ];

    public function campaigns()
    {
        return $this->hasMany(AdCampaign::class, 'position_id');
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}

