<?php

namespace App\Http\Controllers\Frontend\V1;

use App\Http\Controllers\Controller;
use App\Models\News;
use Illuminate\Http\Request;

class NewsController extends Controller
{
    public function show($slug)
    {
        $tenant = app('tenant');
        
        $news = News::where('tenant_id', $tenant->id)
            ->where('slug', $slug)
            ->where('status', 'published')
            ->with(['category', 'author', 'tags', 'gallery.photos'])
            ->firstOrFail();
        
        // Incrementar visualizações
        $news->incrementViews();
        
        // Notícias relacionadas
        $relatedNews = News::where('tenant_id', $tenant->id)
            ->where('status', 'published')
            ->where('id', '!=', $news->id)
            ->where(function($query) use ($news) {
                if ($news->category_id) {
                    $query->where('category_id', $news->category_id);
                }
            })
            ->latest()
            ->take(3)
            ->get();
        
        // Mais lidas
        $mostViewed = News::where('tenant_id', $tenant->id)
            ->where('status', 'published')
            ->where('id', '!=', $news->id)
            ->orderBy('views', 'desc')
            ->take(5)
            ->get();
        
        // Vídeos para sidebar
        $sidebarVideos = \App\Models\Video::where('tenant_id', $tenant->id)
            ->where('status', 'published')
            ->where('publish_on_site', true)
            ->latest()
            ->take(3)
            ->get();
        
        return view('frontend.v1.news.show', compact('news', 'relatedNews', 'mostViewed', 'sidebarVideos'));
    }
}

