<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Video;
use App\Models\Gallery;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $startDate = $request->get('start_date', now()->startOfMonth()->format('Y-m-d'));
        $endDate = $request->get('end_date', now()->format('Y-m-d'));

        // Estatísticas gerais
        $stats = [
            'total_news' => News::count(),
            'published_news' => News::where('status', 'published')->count(),
            'total_views' => News::sum('views'),
            'total_videos' => Video::count(),
            'total_galleries' => Gallery::count(),
            'total_users' => User::count(),
        ];

        // Notícias mais lidas
        $topNews = News::where('status', 'published')
            ->orderBy('views', 'desc')
            ->limit(10)
            ->get();

        // Notícias por categoria
        $newsByCategory = DB::table('news')
            ->join('categories', 'news.category_id', '=', 'categories.id')
            ->select('categories.name', DB::raw('count(*) as total'))
            ->whereBetween('news.created_at', [$startDate, $endDate])
            ->groupBy('categories.id', 'categories.name')
            ->orderBy('total', 'desc')
            ->get();

        // Notícias por autor
        $newsByAuthor = DB::table('news')
            ->join('users', 'news.user_id', '=', 'users.id')
            ->select('users.name', DB::raw('count(*) as total'))
            ->whereBetween('news.created_at', [$startDate, $endDate])
            ->groupBy('users.id', 'users.name')
            ->orderBy('total', 'desc')
            ->limit(10)
            ->get();

        // Estatísticas por período
        $newsPerDay = DB::table('news')
            ->select(DB::raw('DATE(created_at) as date'), DB::raw('count(*) as total'))
            ->whereBetween('created_at', [$startDate, $endDate])
            ->groupBy('date')
            ->orderBy('date')
            ->get();

        return view('admin.reports.index', compact(
            'stats',
            'topNews',
            'newsByCategory',
            'newsByAuthor',
            'newsPerDay',
            'startDate',
            'endDate'
        ));
    }
}

