# ✅ Solução: Erro "Cliente Inativo"

## 🔧 Problema

A API está retornando "Cliente inativo" mesmo quando a licença está ativa.

## ✅ Correção Aplicada

A validação foi ajustada para ser mais flexível:

### Antes:
- Bloqueava se `client_status !== 'active'`

### Agora:
- ✅ Permite instalação mesmo se cliente não estiver 'active'
- ✅ Bloqueia apenas se estiver 'suspended' ou 'cancelled'
- ✅ Permite se estiver 'pending', 'inactive' ou NULL

## 🧪 Verificar Status do Cliente

Acesse este script para verificar e corrigir o status:

```
https://master.canal33.com.br/check-client-status.php?license_key=PVX-2A5DAAA7-4E529016-AEDC8613
```

Este script vai:
1. Mostrar o status atual do cliente
2. Permitir ativar o cliente com um clique
3. Testar a validação após ativar

## 🔧 Ativar Cliente Manualmente

### Via Script:
Acesse: `check-client-status.php?license_key=SUA_CHAVE&activate=yes`

### Via SQL:
```sql
UPDATE clients 
SET status = 'active' 
WHERE id = (SELECT client_id FROM licenses WHERE license_key = 'PVX-2A5DAAA7-4E529016-AEDC8613');
```

### Via Painel Master:
1. Acesse o Painel Master
2. Vá em "Clientes"
3. Encontre o cliente
4. Altere o status para "Ativo"

## ✅ Testar Novamente

Após ativar o cliente, teste novamente:

```
https://master.canal33.com.br/api/v1/validate-license.php?license_key=PVX-2A5DAAA7-4E529016-AEDC8613
```

Deve retornar `{"success": true, ...}` agora! ✅

