# ⚙️ Configuração do Portal de Notícias

## 🔑 Configuração de Licença

### Arquivo .env

Adicione as seguintes variáveis no arquivo `.env`:

```env
# Master Panel
MASTER_PANEL_URL=https://master.canal33.com.br
MASTER_PANEL_LICENSE_KEY=sua_chave_aqui
MASTER_PANEL_API_KEY=sua_api_key_aqui
MASTER_PANEL_API_SECRET=seu_api_secret_aqui
```

### Desabilitar Validação (Apenas Desenvolvimento)

Se você está em ambiente de desenvolvimento e não tem acesso ao Master Panel:

```env
MASTER_PANEL_DISABLE_CHECK=true
```

⚠️ **NUNCA deixe isso ativado em produção!**

### Limpar Cache Após Configurar

```bash
php artisan config:clear
php artisan cache:clear
```

## 📝 Outras Configurações

### Banco de Dados

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=portal_noticias
DB_USERNAME=seu_usuario
DB_PASSWORD=sua_senha
```

### Aplicação

```env
APP_NAME="Portal de Notícias"
APP_ENV=production
APP_KEY=base64:...
APP_DEBUG=false
APP_URL=https://seu-dominio.com.br
```

## 🔍 Verificar Configuração

Após configurar, você pode verificar se está tudo certo acessando:

- Painel Admin: `/admin`
- Front-end: `/`

Se houver erro de licença, verifique:
1. Se a URL do Master Panel está correta
2. Se a chave de licença está correta
3. Se há conexão com a internet
4. Se o Master Panel está online

