# ✅ Correção: Erro Monolog/PSR Log

## 🔧 Problema
**Erro:** `Declaration of Monolog\Logger::emergency(Stringable|string $message, array $context = []): void must be compatible with PsrExt\Log\LoggerInterface::emergency($message, array $context = [])`

**Causa:** Conflito de versões entre `monolog/monolog` e `psr/log`. O PHP 8.2 pode ter mudanças que causam incompatibilidade.

## ✅ Solução

### Opção 1: Atualizar dependências (Recomendado)
Execute no servidor via SSH:
```bash
cd /home/canal33portal/public_html
composer update monolog/monolog psr/log --with-all-dependencies
```

### Opção 2: Forçar versões compatíveis
Edite o `composer.json` e adicione:
```json
"require": {
    "psr/log": "^3.0",
    "monolog/monolog": "^3.0"
}
```

Depois execute:
```bash
composer update psr/log monolog/monolog
```

### Opção 3: Remover e reinstalar
```bash
cd /home/canal33portal/public_html
rm -rf vendor/
composer install --no-dev --optimize-autoloader
```

## 🚀 Solução Rápida (Script PHP)

Criei um script que tenta corrigir automaticamente.

