<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\PostController as FrontendPostController;
use App\Http\Controllers\Frontend\CategoryController;
use App\Http\Controllers\Auth\LoginController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Instalador
Route::get('/install', function () {
    if (file_exists(storage_path('app/installed.lock'))) {
        return redirect()->route('admin.dashboard');
    }
    return redirect('/install/index.php');
});

// Autenticação
Route::get('/admin/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/admin/login', [LoginController::class, 'login']);
Route::post('/admin/logout', [LoginController::class, 'logout'])->name('logout');

// Rotas Admin (protegidas)
Route::middleware(['auth', 'license.check'])->prefix('admin')->name('admin.')->group(function () {
    
    Route::get('/', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index']);
    
    // Notícias
    Route::resource('posts', \App\Http\Controllers\Admin\PostController::class);
    Route::post('posts/{post}/duplicate', [\App\Http\Controllers\Admin\PostController::class, 'duplicate'])->name('posts.duplicate');
    Route::post('posts/{post}/status', [\App\Http\Controllers\Admin\PostController::class, 'changeStatus'])->name('posts.change-status');
    
    // Categorias
    Route::resource('categories', \App\Http\Controllers\Admin\CategoryController::class);
    
    // Vídeos
    Route::resource('videos', \App\Http\Controllers\Admin\VideoController::class);
    
    // Galerias
    Route::resource('galleries', \App\Http\Controllers\Admin\GalleryController::class);
    
    // Enquetes
    Route::resource('polls', \App\Http\Controllers\Admin\PollController::class);
    
    // Anúncios
    Route::resource('ads', \App\Http\Controllers\Admin\AdController::class);
    
    // Leitores
    Route::resource('readers', \App\Http\Controllers\Admin\ReaderController::class);
    
    // Notificações
    Route::get('notifications', [\App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('notifications.index');
    Route::post('notifications/send', [\App\Http\Controllers\Admin\NotificationController::class, 'send'])->name('notifications.send');
    
    // Configurações
    Route::get('settings', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('settings.index');
    Route::post('settings', [\App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('settings.update');
    
    // Usuários
    Route::resource('users', \App\Http\Controllers\Admin\UserController::class);
});

// Rotas Públicas (Frontend)
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/noticia/{slug}', [FrontendPostController::class, 'show'])->name('post.show');
Route::get('/categoria/{slug}', [CategoryController::class, 'show'])->name('category.show');
Route::get('/busca', [FrontendPostController::class, 'search'])->name('search');

