@extends('layouts.admin')

@section('title', 'Nova Notícia')

@section('content')
<div class="card">
    <div class="card-header">
        <h5>Nova Notícia</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.posts.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="row">
                <div class="col-md-8">
                    <div class="mb-3">
                        <label class="form-label">Título *</label>
                        <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Subtítulo</label>
                        <input type="text" name="subtitle" class="form-control" value="{{ old('subtitle') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Chapéu</label>
                        <input type="text" name="hat" class="form-control" value="{{ old('hat') }}" placeholder="Ex: Política">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Fonte</label>
                        <input type="text" name="source" class="form-control" value="{{ old('source') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Corpo da Notícia *</label>
                        <textarea name="body" class="form-control" rows="15" required>{{ old('body') }}</textarea>
                        <small class="text-muted">HTML permitido</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Resumo/Excerpt</label>
                        <textarea name="excerpt" class="form-control" rows="3">{{ old('excerpt') }}</textarea>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">Categoria *</label>
                        <select name="category_id" class="form-select" required>
                            <option value="">Selecione...</option>
                            @foreach($categories as $cat)
                                <option value="{{ $cat->id }}" {{ old('category_id') == $cat->id ? 'selected' : '' }}>
                                    {{ $cat->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Foto de Capa</label>
                        <input type="file" name="cover_image" class="form-control" accept="image/*">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Crédito da Foto</label>
                        <input type="text" name="credit" class="form-control" value="{{ old('credit') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>Rascunho</option>
                            <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>Pendente</option>
                            <option value="published" {{ old('status') == 'published' ? 'selected' : '' }}>Publicado</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Data/Hora de Publicação</label>
                        <input type="datetime-local" name="published_at" class="form-control" value="{{ old('published_at') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Acesso</label>
                        <select name="access" class="form-select">
                            <option value="public" {{ old('access') == 'public' ? 'selected' : '' }}>Público</option>
                            <option value="subscribed" {{ old('access') == 'subscribed' ? 'selected' : '' }}>Assinantes</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="featured" class="form-check-input" id="featured" {{ old('featured') ? 'checked' : '' }}>
                            <label class="form-check-label" for="featured">Destaque</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="is_slide" class="form-check-input" id="is_slide" {{ old('is_slide') ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_slide">Slide</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="is_manchete" class="form-check-input" id="is_manchete" {{ old('is_manchete') ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_manchete">Manchete</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="is_urgent" class="form-check-input" id="is_urgent" {{ old('is_urgent') ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_urgent">Urgente 24h</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="show_in_more_news" class="form-check-input" id="show_in_more_news" {{ old('show_in_more_news') ? 'checked' : '' }}>
                            <label class="form-check-label" for="show_in_more_news">Mais Notícias</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="whatsapp_notification" class="form-check-input" id="whatsapp_notification">
                            <label class="form-check-label" for="whatsapp_notification">Enviar WhatsApp</label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Tags (separadas por vírgula)</label>
                        <input type="text" name="tags" class="form-control" value="{{ old('tags') }}" placeholder="tag1, tag2, tag3">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Meta Title (SEO)</label>
                        <input type="text" name="meta_title" class="form-control" value="{{ old('meta_title') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Meta Description (SEO)</label>
                        <textarea name="meta_description" class="form-control" rows="2">{{ old('meta_description') }}</textarea>
                    </div>
                </div>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Salvar Notícia
                </button>
                <a href="{{ route('admin.posts.index') }}" class="btn btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
</div>
@endsection

