<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NotificationTemplatesSeeder extends Seeder
{
    public function run(): void
    {
        $templates = [
            [
                'name' => 'Nova Notícia Publicada',
                'type' => 'new_post',
                'content' => "📰 *Nova matéria publicada!*\n📌 *{titulo}*\n🕒 {data_hora}\n\n{descricao_curta}\n\n🔗 Leia agora: {link}",
                'variables' => json_encode(['titulo', 'data_hora', 'descricao_curta', 'link']),
                'active' => true,
                'include_image' => true,
            ],
            [
                'name' => 'Nova Notícia Premium',
                'type' => 'new_post_premium',
                'content' => "🚨 *ATENÇÃO, {nome}! Acabou de sair uma notícia quente 🔥*\n\n🗞️ *{titulo}*\n📍 Categoria: {categoria}\n🗓️ Publicado às: {data_hora}\n\n👉 {descricao_curta}\n\nClique e leia agora 👇\n{link}",
                'variables' => json_encode(['nome', 'titulo', 'categoria', 'data_hora', 'descricao_curta', 'link']),
                'active' => true,
                'include_image' => true,
            ],
            [
                'name' => 'Pagamento Confirmado',
                'type' => 'payment_confirmed',
                'content' => "🎉 *Pagamento Confirmado!*\n\nOlá, {nome}. Sua assinatura foi aprovada com sucesso!\nObrigado por apoiar nosso portal e continuar recebendo notícias em primeira mão 🗞️🔥\n\n📅 Renovação: {data_renovacao}\n🔗 Acesse o painel: {link}",
                'variables' => json_encode(['nome', 'data_renovacao', 'link']),
                'active' => true,
                'include_image' => false,
            ],
            [
                'name' => 'Pagamento Renovado',
                'type' => 'payment_renewed',
                'content' => "🔁 *Assinatura Renovada com Sucesso!*\n\nSeu plano foi renovado e você continua tendo acesso total às nossas notícias exclusivas.\nObrigado por permanecer conosco! 🙌",
                'variables' => json_encode([]),
                'active' => true,
                'include_image' => false,
            ],
            [
                'name' => 'Pagamento Cancelado',
                'type' => 'payment_cancelled',
                'content' => "⚠️ *Assinatura Cancelada*\n\nOlá, {nome}. Sua assinatura foi cancelada.\nSe isso foi um engano, você pode reativar rapidamente no link abaixo:\n\n🔗 {link_reativacao}\n\nContinuamos à disposição! 🙂",
                'variables' => json_encode(['nome', 'link_reativacao']),
                'active' => true,
                'include_image' => false,
            ],
            [
                'name' => 'Cadastro Cancelado',
                'type' => 'registration_cancelled',
                'content' => "❌ *Você cancelou o recebimento de notícias*\n\n{nome}, você não receberá mais nossos alertas no WhatsApp.\n\nSe quiser voltar, basta acessar:\n👉 {link_cadastro}\n\nObrigado por acompanhar nosso portal! 🙏",
                'variables' => json_encode(['nome', 'link_cadastro']),
                'active' => true,
                'include_image' => false,
            ],
            [
                'name' => 'Aviso Importante',
                'type' => 'important_notice',
                'content' => "📢 *Aviso Importante*\n\n{mensagem_personalizada}\n\n🗞️ Equipe {nome_do_portal}",
                'variables' => json_encode(['mensagem_personalizada', 'nome_do_portal']),
                'active' => true,
                'include_image' => false,
            ],
            [
                'name' => 'Nova Enquete',
                'type' => 'new_poll',
                'content' => "🗳️ *Nova Enquete Disponível!*\n\nParticipe agora:\n{pergunta}\n\n👉 Vote aqui: {link}",
                'variables' => json_encode(['pergunta', 'link']),
                'active' => true,
                'include_image' => false,
            ],
            [
                'name' => 'Destaque do Dia',
                'type' => 'daily_highlight',
                'content' => "🌅 *Bom dia, {nome}!*\n\nAqui está o destaque do dia em nosso portal 👇\n{link}\n\nDesejamos uma ótima semana! ✨",
                'variables' => json_encode(['nome', 'link']),
                'active' => true,
                'include_image' => true,
            ],
        ];

        foreach ($templates as $template) {
            DB::table('notifications_templates')->insert(array_merge($template, [
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}

