<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Setting;

class InitialSeeder extends Seeder
{
    public function run(): void
    {
        // Criar categorias padrão
        $categories = [
            ['name' => 'Política', 'slug' => 'politica', 'color' => '#dc3545', 'order' => 1],
            ['name' => 'Esportes', 'slug' => 'esportes', 'color' => '#28a745', 'order' => 2],
            ['name' => 'Economia', 'slug' => 'economia', 'color' => '#ffc107', 'order' => 3],
            ['name' => 'Tecnologia', 'slug' => 'tecnologia', 'color' => '#17a2b8', 'order' => 4],
            ['name' => 'Cultura', 'slug' => 'cultura', 'color' => '#6f42c1', 'order' => 5],
            ['name' => 'Saúde', 'slug' => 'saude', 'color' => '#e83e8c', 'order' => 6],
        ];

        foreach ($categories as $cat) {
            Category::firstOrCreate(['slug' => $cat['slug']], $cat);
        }

        // Configurações padrão
        Setting::set('active_template', 'v1', 'string', 'appearance');
        Setting::set('site_name', 'Portal Bahia', 'string', 'general');
        Setting::set('site_description', 'Portal de notícias', 'string', 'general');
    }
}

