<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');
            $table->string('title');
            $table->enum('provider', ['youtube', 'vimeo', 'upload', 'embed'])->default('youtube');
            $table->string('provider_id')->nullable(); // ID do vídeo no YouTube/Vimeo
            $table->text('url')->nullable(); // URL completa ou embed code
            $table->string('thumbnail')->nullable();
            $table->text('description')->nullable();
            $table->json('tags')->nullable();
            $table->boolean('publish_on_site')->default(true);
            $table->boolean('push_notification')->default(false);
            $table->enum('status', ['draft', 'published', 'archived'])->default('draft');
            $table->timestamp('published_at')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('status');
            $table->index('published_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('videos');
    }
};

