<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('reader_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('template_id')->nullable()->constrained('notifications_templates')->onDelete('set null');
            $table->string('type'); // whatsapp, email, push
            $table->string('to'); // Número, email, etc
            $table->text('message'); // Mensagem enviada
            $table->json('variables')->nullable(); // Variáveis usadas
            $table->enum('status', ['pending', 'sent', 'failed', 'delivered'])->default('pending');
            $table->text('api_response')->nullable(); // Resposta da API
            $table->text('error_message')->nullable();
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();
            
            $table->index('reader_id');
            $table->index('status');
            $table->index('sent_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications_history');
    }
};

