<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Nome do template
            $table->string('type'); // new_post, payment_confirmed, payment_renewed, etc
            $table->text('content'); // Conteúdo do template com variáveis {nome}, {titulo}, etc
            $table->json('variables')->nullable(); // Lista de variáveis disponíveis
            $table->boolean('active')->default(true);
            $table->boolean('include_image')->default(false); // Incluir imagem da matéria
            $table->timestamps();
            
            $table->index('type');
            $table->index('active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications_templates');
    }
};

