<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reader extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'whatsapp_number',
        'categories_interest',
        'receive_group',
        'receive_private',
        'city',
        'state',
        'status',
        'last_notification_at',
    ];

    protected $casts = [
        'categories_interest' => 'array',
        'receive_group' => 'boolean',
        'receive_private' => 'boolean',
        'last_notification_at' => 'datetime',
    ];

    public function notifications()
    {
        return $this->hasMany(NotificationHistory::class);
    }
}

