<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationTemplate extends Model
{
    use HasFactory;

    protected $table = 'notifications_templates';

    protected $fillable = [
        'name',
        'type',
        'content',
        'variables',
        'active',
        'include_image',
    ];

    protected $casts = [
        'variables' => 'array',
        'active' => 'boolean',
        'include_image' => 'boolean',
    ];

    /**
     * Renderizar template com variáveis
     */
    public function render(array $variables): string
    {
        $content = $this->content;
        
        foreach ($variables as $key => $value) {
            $content = str_replace('{' . $key . '}', $value, $content);
        }
        
        return $content;
    }
}

