<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationHistory extends Model
{
    use HasFactory;

    protected $table = 'notifications_history';

    protected $fillable = [
        'reader_id',
        'template_id',
        'type',
        'to',
        'message',
        'variables',
        'status',
        'api_response',
        'error_message',
        'sent_at',
    ];

    protected $casts = [
        'variables' => 'array',
        'sent_at' => 'datetime',
    ];

    public function reader()
    {
        return $this->belongsTo(Reader::class);
    }

    public function template()
    {
        return $this->belongsTo(NotificationTemplate::class);
    }
}

