<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Gallery extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'post_id',
        'title',
        'description',
        'cover_image',
        'push_notification',
        'whatsapp_notification',
        'facebook_notification',
        'status',
        'published_at',
    ];

    protected $casts = [
        'push_notification' => 'boolean',
        'whatsapp_notification' => 'boolean',
        'facebook_notification' => 'boolean',
        'published_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function post()
    {
        return $this->belongsTo(Post::class);
    }

    public function images()
    {
        return $this->hasMany(GalleryImage::class)->orderBy('order');
    }
}

