<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class CreateAdminCommand extends Command
{
    protected $signature = 'portal:create-admin 
                            {--name= : Nome do administrador}
                            {--email= : Email do administrador}
                            {--password= : Senha do administrador}';

    protected $description = 'Criar usuário administrador';

    public function handle()
    {
        $name = $this->option('name') ?: $this->ask('Nome do administrador');
        $email = $this->option('email') ?: $this->ask('Email do administrador');
        $password = $this->option('password') ?: $this->secret('Senha do administrador');

        if (User::where('email', $email)->exists()) {
            $this->error('Usuário com este email já existe!');
            return 1;
        }

        User::create([
            'name' => $name,
            'email' => $email,
            'password' => Hash::make($password),
            'is_admin' => true,
        ]);

        $this->info('Administrador criado com sucesso!');
        return 0;
    }
}

